/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.factory.PowerFactory;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class PowerType<T extends Power> {
    private ResourceLocation identifier;
    private PowerFactory.Instance factory;
    private boolean isHidden = false;
    private String nameTranslationKey;
    private String descriptionTranslationKey;

    public PowerType(ResourceLocation id, PowerFactory.Instance factory) {
        this.identifier = id;
        this.factory = factory;
    }

    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public PowerFactory.Instance getFactory() {
        return this.factory;
    }

    public PowerType<T> setHidden() {
        this.isHidden = true;
        return this;
    }

    public void setTranslationKeys(String name, String description) {
        this.nameTranslationKey = name;
        this.descriptionTranslationKey = description;
    }

    public T create(PlayerEntity player) {
        return (T)this.factory.apply(this, player);
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isActive(Entity entity) {
        OriginComponent component;
        if (entity instanceof PlayerEntity && this.identifier != null && (component = ModComponentsArchitectury.getOriginComponent(entity)).hasPower(this)) {
            return ((Power)component.getPower(this)).isActive();
        }
        return false;
    }

    public T get(Entity entity) {
        if (entity instanceof PlayerEntity) {
            OriginComponent component = ModComponentsArchitectury.getOriginComponent(entity);
            return component.getPower(this);
        }
        return null;
    }

    public String getOrCreateNameTranslationKey() {
        if (this.nameTranslationKey == null || this.nameTranslationKey.isEmpty()) {
            this.nameTranslationKey = "power." + this.identifier.func_110624_b() + "." + this.identifier.func_110623_a() + ".name";
        }
        return this.nameTranslationKey;
    }

    public TranslationTextComponent getName() {
        return new TranslationTextComponent(this.getOrCreateNameTranslationKey());
    }

    public String getOrCreateDescriptionTranslationKey() {
        if (this.descriptionTranslationKey == null || this.descriptionTranslationKey.isEmpty()) {
            this.descriptionTranslationKey = "power." + this.identifier.func_110624_b() + "." + this.identifier.func_110623_a() + ".description";
        }
        return this.descriptionTranslationKey;
    }

    public TranslationTextComponent getDescription() {
        return new TranslationTextComponent(this.getOrCreateDescriptionTranslationKey());
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PowerType)) {
            return false;
        }
        ResourceLocation id = ((PowerType)obj).getIdentifier();
        return this.identifier.equals((Object)id);
    }
}

